<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.InterviewerFilter" Theme="Voxco"
    Title="<%$ Resources:Resource, VoxcoReporting%>" EnableSessionState="True" Trace="false" Async="true" Codebehind="InterviewerFilter.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">

<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
	<script type="text/javascript">
	   
			function treeSelectedDropTest(source, dest, events)
			{
				if(dest!= null && dest.Value.substring(0, 3) == "OG:" && source.Parent != null && source.Parent.Value != dest.Value)
				{
					return true;
				}
				// allow moving all group's elements in another group
				if(dest!= null && source.Value.substring(0, 3) == "OG:" && dest.Value.substring(0, 3) == "OG:")
				{
					return true;
				}
				return false;
			}
	        
			function ContextMenuClick(node, itemText)
			{
				if (itemText == "Disable")
				{
					node.Disable();
					return false;
				}
				if (itemText == "Enable All")
				{
					for (var i=0; i<node.TreeView.AllNodes.length; i++)
					{
						node.TreeView.AllNodes[i].Enable();
					}
				}
				if (itemText == "Edit")
				{        
					node.StartEdit();
				}
	            
				return true;
			}
	        
			function UpdateAllChildren(nodes, checked)
			{
				for (i=0; i<nodes.length; i++)
				{
					checked ? nodes[i].Check() : nodes[i].UnCheck(); 
					if (nodes[i].Nodes.length > 0)
					{
						UpdateAllChildren(nodes[i].Nodes, checked);    
					}
				}
			}

			function OnCheckedNode(node)
			{
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes");
			}
	        
			function grdSelectedInterviewers_OnColumnClick(index)
			{
				if(index == 0)
				{
					window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("ToggleSelectAllFiltered");
				}
			}
			function grdAvailableInterviewers_OnColumnClick(index)
			{
				if(index == 0)
				{
					window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("ToggleSelectAllAvailable");
				}
			}
	        
			var searchValue = null;
			function FindTextBox_OnValueChanged(sender, e)
			{
				searchValue = e.NewValue;
				FindAgent(e.NewValue);
			}
	        
			function FindTextBox_OnButtonClick(sender, e)
			{
				FindAgent(searchValue);
			}

			function FindAgent(value)
			{
				window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("FindAgent:"+value);
	            
				return false;
			}
	        
			function MoveByXPos()
			{
				radprompt('<%= TranslateForJS("MoveCountPrompt") %>', MoveByXPos_PromptCallBack, 500, 50);
				return false;
			}
	        
			function MoveByXPos_PromptCallBack(_moveCount)
			{
				if( _moveCount != null && _moveCount != '' )
				{
					window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("MoveByXPos:" + _moveCount);
				}
			}

			function MoveToLast()
			{
			  window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("MoveGroupToLast");
			  return false;
			}
		</script>
	</telerik:RadScriptBlock>
    
    <asp:ObjectDataSource ID="AvailableInterviewerListDataSource" runat="server" SelectMethod="GetGenericInterviewerLists"
        TypeName="Voxco.Reporting.DataSource.Interviewers">
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" Height="500px" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="RadAjaxPanel2_OnAjaxRequest" CssClass="mainContent">
        
		<telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" >
			<VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
		</telerik:RadAjaxLoadingPanel>
            
        <asp:RadioButtonList ID="choiceSelectionType" runat="server" Visible="True" RepeatDirection="Horizontal" 
         AutoPostBack="true" OnSelectedIndexChanged="choiceSelectionType_OnSelectedIndexChanged">
            <asp:ListItem Value="AllInterviewers" Text="<%$ Resources:Resource, AllInterviewers%>" Selected="True"></asp:ListItem>
            <asp:ListItem Value="SelectInterviewers" Text="<%$ Resources:Resource, SelectInterviewers%>"></asp:ListItem>
        </asp:RadioButtonList>
            
        <asp:Panel ID="IncludeAllInterviewersLabel" runat="server" GroupingText=" ">
			<asp:Label ID="IncludeAllInterviewersLabel2" runat="server" Text="<%$ Resources:Resource, AllAvailableInterviewersWillBeSelected %>"></asp:Label>
		</asp:Panel>
			
        <asp:Panel ID="RadSplitter1" runat="server" Height="100%">
            
            <div style="width:45%; height:100%; float: left;">
            				
				<asp:Label ID="TitleAvailableInterviewers" runat="server" Text="<%$ Resources:Resource, AvailableInterviewers %>" CssClass="title"></asp:Label>
				
                <telerik:RadGrid ID="grdAvailableInterviewers" runat="server" EnableViewState="true"
                AllowSorting="false" OnNeedDataSource="grdAvailableInterviewers_OnNeedDataSource"
                OnPageIndexChanged="grdAvailableInterviewers_PageIndexChanged" OnDataBound="grdAvailableInterviewers_OnDataBound"
                AllowMultiRowSelection="True" AutoGenerateColumns="False"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">                    
                    <ClientSettings>
                        <Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
                        <Scrolling AllowScroll="true" UseStaticHeaders="true" />
                        <ClientEvents OnColumnClick="grdAvailableInterviewers_OnColumnClick" />
                    </ClientSettings>
                    <MasterTableView NoMasterRecordsText="" Width="100%">
                        <SortExpressions>
                            <telerik:GridSortExpression FieldName="Name" SortOrder="Ascending" />
                        </SortExpressions>
                        <Columns>
                            <telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ParentId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
                            </telerik:GridBoundColumn>
                            <telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
                                <HeaderStyle Width="10%" HorizontalAlign="Left" />
                                <ItemStyle Width="10%" HorizontalAlign="Left" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, AvailableInterviewers %>" UniqueName="Name">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>                   
				</telerik:RadGrid>

				
				<asp:Label ID="TitleInterviewersList" runat="server" Text="<%$ Resources:Resource, InterviewerList %>" CssClass="title"></asp:Label>
				<asp:DropDownList ID="cboInterviewerList" runat="server" Width="162px" DataSourceID="AvailableInterviewerListDataSource" DataTextField="Name" DataValueField="ID"></asp:DropDownList>
        
            </div>
            
            <div style="width: 25px; float: left;">
            
				<asp:Panel ID="RadPaneInterviewerButtonsCol12" runat="server" Height="360px" HorizontalAlign="Center">				
				<div class="arrows">
					<asp:ImageButton ID="btnAddInterviewer" runat="server" ImageUrl="~/icons/arrow_right_blue.png" ToolTip="<%$ Resources:Resource, AddSelectedItems %>"  OnClick="btnAddInterviewer_OnClick" />
					<asp:ImageButton ID="btnRemoveInterviewer" runat="server" ImageUrl="~/icons/arrow_left_blue.png" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>" OnClick="btnRemoveInterviewer_OnClick" />
				</div>				
				</asp:Panel>
				
				<asp:Panel ID="b2" runat="server" HorizontalAlign="Center">					
					<asp:ImageButton ID="ImageButton1" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddInterviewersFromList_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" />                
				</asp:Panel>
				
            </div>
                 
			<div style="width:45%; height:100%; float: left;">       
				<asp:Label ID="TitleFilteredInterviewers" runat="server" Text="<%$ Resources:Resource, FilteredInterviewers %>" CssClass="title"></asp:Label>
            
				<telerik:RadGrid ID="grdSelectedInterviewers" runat="server" Height="360px" EnableViewState="true"
				AllowSorting="false" OnNeedDataSource="grdSelectedInterviewers_OnNeedDataSource"
				OnPageIndexChanged="grdSelectedInterviewers_PageIndexChanged" OnDataBound="grdSelectedInterviewers_OnDataBound"
				AllowMultiRowSelection="True" AutoGenerateColumns="False"
				EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">                    
					<ClientSettings>
						<Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
						<Scrolling AllowScroll="true" UseStaticHeaders="true" />
						<ClientEvents OnColumnClick="grdSelectedInterviewers_OnColumnClick" />
					</ClientSettings>
					<MasterTableView NoMasterRecordsText="" Width="100%">
						<SortExpressions>
							<telerik:GridSortExpression FieldName="Name" SortOrder="Ascending" />
						</SortExpressions>
						<Columns>
							<telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
							</telerik:GridBoundColumn>
							<telerik:GridBoundColumn DataField="ParentId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
							</telerik:GridBoundColumn>
							<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
								<HeaderStyle Width="10%" HorizontalAlign="Left" />
								<ItemStyle Width="10%" HorizontalAlign="Left" />
							</telerik:GridClientSelectColumn>
							<telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, FilteredInterviewers %>" UniqueName="Name">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
							</telerik:GridBoundColumn>
							<telerik:GridBoundColumn DataField="Invalid" UniqueName="Invalid" Display="false" ></telerik:GridBoundColumn>
						</Columns>
					</MasterTableView>                    
				</telerik:RadGrid>      
            </div>
		</asp:Panel>
        
    </telerik:RadAjaxPanel>
    
</asp:Content>

